set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2221',
      NULL,
      NULL,
      45.840636,
      '4134301',
      NULL,
      2,
      0,
      NULL,
      NULL,
      6.053694,
      ' 0-16-1976',
      1.323525,
      21,
      0,
      NULL,
      1,
      1,
      0.154148,
      0.615294,
      NULL,
      1.669701,
      1,
      NULL,
      0,
      1,
      3.038170,
      0.416013,
      NULL,
      1,
      0.800408,
      NULL,
      NULL,
      1.706290,
      1.645473,
      0,
      0.363870,
      0,
      3.261097,
      1,
      NULL,
      NULL,
      3.736370,
      1.260159,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.362390,
      1.309025,
      0,
      1.234207,
      1,
      0,
      2.801661,
      1.683603,
      1,
      NULL,
      NULL,
      NULL,
      0.964356,
      3.166276,
      1,
      0.672203,
      1,
      NULL,
      6,
      1.793754,
      1,
      6,
      NULL,
      0,
      1.429888,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.813066,
      NULL,
      1.218137,
      NULL,
      0.985172,
      1,
      1,
      0.737710,
      0.217580,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.214824,
      NULL,
      0,
      0.721232,
      1,
      0,
      NULL,
      0.361251,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.428960,
      3.175875,
      3,
      4,
      4,
      8,
      NULL,
      NULL,
      3,
      1,
      1.710832,
      2.253196,
      3.305231,
      3,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945252,
      1,
      1,
      NULL,
      0.700074,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.200542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.966316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877902,
      1,
      NULL,
      NULL,
      1.901374,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.436577,
      NULL,
      1.663735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157555,
      2.372040,
      0.083294,
      NULL,
      0,
      0,
      1,
      0.174315,
      NULL,
      NULL,
      0.608405,
      NULL,
      1,
      1.286503,
      0,
      0.770964,
      1,
      1.164819,
      1.783122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.852616,
      1.339857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.330921,
      0.136739,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838684,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.028783,
      NULL,
      1.697708,
      1,
      1.836179,
      0,
      4.027354,
      NULL,
      '42022',
      '',
      1.606515,
      '',
      NULL,
      '',
      5,
      NULL,
      '30131',
      '4122',
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      1.581881,
      3);
commit;
end;
/


