set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9988431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      8.888884,
      85.229191,
      '1441320',
      7,
      3,
      NULL,
      3,
      NULL,
      5,
      ' 3-25-1988',
      27.128576,
      33.190289,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.294022,
      1.902542,
      1,
      1.345138,
      NULL,
      2.449090,
      NULL,
      2.382421,
      0,
      NULL,
      NULL,
      0.109353,
      0.522411,
      0,
      NULL,
      NULL,
      1.960415,
      0,
      0,
      3,
      0,
      0.481815,
      1.422900,
      2,
      NULL,
      NULL,
      NULL,
      0.561894,
      NULL,
      NULL,
      0.200494,
      0.646191,
      NULL,
      0.212058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162756,
      1.704841,
      0.107808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029086,
      1.874146,
      NULL,
      NULL,
      0.447467,
      1,
      1.462440,
      0,
      1.660447,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1.935509,
      1,
      NULL,
      1,
      4.078478,
      1,
      NULL,
      3.500729,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      0.160933,
      4,
      0,
      1.451469,
      4.033541,
      3,
      3,
      NULL,
      4.442190,
      4,
      4.255363,
      6,
      1.411902,
      1.066009,
      1,
      1,
      NULL,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822757,
      NULL,
      0,
      0,
      1,
      NULL,
      0.062373,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.511990,
      2.625459,
      3,
      1.627232,
      0.992465,
      3,
      3.732373,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.350056,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.506648,
      4.696008,
      0.115993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.679090,
      0,
      3.566210,
      3.449111,
      3,
      3,
      0.787256,
      0.781714,
      1.635514,
      0,
      0.957507,
      NULL,
      0.330367,
      0,
      1,
      0,
      1.437243,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.232808,
      '10031',
      '',
      '',
      0.752126,
      '',
      '',
      '',
      1.268342,
      '',
      '',
      '',
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      2.327100,
      3,
      NULL);
commit;
end;
/


