set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9988431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1022',
      '12404340',
      39.121469,
      NULL,
      '1343440',
      24.840819,
      NULL,
      0.813768,
      1,
      NULL,
      0,
      ' 9-29-1987',
      36.012820,
      31,
      NULL,
      NULL,
      3,
      1.752270,
      0,
      1,
      0.611407,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      1,
      1,
      6.346843,
      2.160917,
      NULL,
      11.206623,
      NULL,
      1,
      5.173941,
      5.289222,
      1,
      3.416329,
      NULL,
      2.957299,
      5,
      2.015051,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.697637,
      9.597140,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      0,
      1,
      0.604436,
      1,
      2.776690,
      1,
      3,
      NULL,
      0.168275,
      1.963455,
      1.319074,
      2,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.800804,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.353913,
      4,
      5.630494,
      1.395203,
      NULL,
      0.776976,
      0,
      NULL,
      0,
      1.927730,
      0,
      1.856151,
      0.005341,
      1,
      1.317697,
      0.146662,
      NULL,
      0,
      1.837817,
      NULL,
      0.788948,
      3.729346,
      0,
      1,
      1.362911,
      0.482698,
      0.556690,
      1.795389,
      NULL,
      0,
      1.944582,
      0.735945,
      0,
      1,
      2,
      5,
      3,
      2,
      4.421630,
      NULL,
      1.389789,
      0.029370,
      2,
      1,
      0,
      NULL,
      0.726358,
      0,
      0,
      NULL,
      0.252546,
      0.097656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915978,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1.213997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353452,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511922,
      3,
      0,
      1.817403,
      1,
      4,
      NULL,
      3.210645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.563869,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.079055,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.295505,
      0.616840,
      3.556660,
      1.027301,
      1,
      1.536623,
      0.064686,
      2,
      NULL,
      0,
      NULL,
      0.136103,
      0.662278,
      1,
      NULL,
      NULL,
      NULL,
      1.458791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10322',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      0,
      0,
      NULL,
      NULL,
      3,
      1.026794,
      3.205970,
      0);
commit;
end;
/


