set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      '20',
      5,
      25.865777,
      '0444302',
      7.496999,
      NULL,
      1.926585,
      NULL,
      '220410',
      4.336364,
      ' 7-23-2002',
      9,
      45,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.422508,
      NULL,
      1.577592,
      3.878192,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      4.447320,
      1.052249,
      1.462342,
      1,
      2,
      0.348183,
      1,
      0,
      6,
      0,
      2,
      NULL,
      2.797242,
      1.417641,
      NULL,
      NULL,
      1.694787,
      NULL,
      NULL,
      1.123577,
      3,
      3.532142,
      3,
      1,
      0,
      2,
      1,
      0.905784,
      0.251416,
      0,
      0,
      3,
      0.029419,
      3.945749,
      3.236503,
      1.586091,
      NULL,
      2.777567,
      1.331938,
      1,
      5,
      NULL,
      NULL,
      0,
      3,
      1.008780,
      NULL,
      NULL,
      0.234000,
      NULL,
      NULL,
      0.105828,
      NULL,
      1,
      0.886993,
      3.542950,
      0,
      NULL,
      NULL,
      1.889486,
      0,
      0.040267,
      NULL,
      NULL,
      0,
      0.122233,
      1,
      1,
      1,
      0.234655,
      NULL,
      0,
      3,
      0.058066,
      1,
      1.312558,
      NULL,
      1.658182,
      0.781763,
      3,
      0.538820,
      0,
      0,
      0,
      1.623945,
      3.806480,
      NULL,
      4.631734,
      NULL,
      NULL,
      5.910244,
      0.329799,
      7.408041,
      NULL,
      1.362692,
      3.216439,
      0,
      1.548908,
      NULL,
      3,
      0,
      1,
      8,
      1.486985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772099,
      2,
      2,
      1.866498,
      0,
      0,
      0.237266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.979556,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.932191,
      NULL,
      2.059748,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.557374,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251235,
      NULL,
      1.273069,
      3.216076,
      2,
      1.530616,
      3.530922,
      NULL,
      2.318116,
      3.446959,
      1.944699,
      1,
      0,
      NULL,
      0.940547,
      1.711082,
      1.466671,
      0.749577,
      0,
      1,
      0.901125,
      0.023157,
      1,
      0.561596,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.725456,
      NULL,
      NULL,
      1.796992,
      NULL,
      1,
      0,
      1.433934,
      '03440',
      '04141',
      '',
      1.240877,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


