set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '14',
      13,
      1,
      '0021022',
      0.786880,
      5,
      2,
      1,
      '002340',
      3,
      ' 6-18-1988',
      NULL,
      137.774512,
      1.928282,
      NULL,
      NULL,
      1,
      NULL,
      0.060027,
      0.406676,
      1.104733,
      0,
      0,
      0.579515,
      1.375637,
      1.505367,
      1,
      2.310368,
      NULL,
      6,
      1.152248,
      1,
      1.817346,
      NULL,
      0,
      0.371834,
      1.155478,
      7.995534,
      1,
      3,
      NULL,
      3.417094,
      1.361003,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.972358,
      5.599122,
      2.305971,
      2.863996,
      1.957550,
      2,
      1.822071,
      1,
      3.623030,
      0.873195,
      1,
      1.766154,
      3,
      1.683114,
      2.175189,
      0,
      0,
      3,
      2,
      0,
      1,
      1.249841,
      7,
      1,
      2,
      0,
      1.334380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.046659,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.101697,
      2.395194,
      0,
      1,
      NULL,
      0.748312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523123,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415816,
      4.393942,
      0.173193,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791584,
      3,
      0,
      4,
      5.986420,
      4.524316,
      1,
      3,
      5,
      6,
      6,
      6,
      NULL,
      1.518639,
      2,
      1.553068,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.638319,
      0,
      2,
      1.335916,
      1.012088,
      1.008552,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188023,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.707307,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.255485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.853164,
      3,
      0,
      3,
      NULL,
      1,
      1.741128,
      3,
      NULL,
      1.465173,
      0.701373,
      1.211346,
      0,
      1.315249,
      0.748402,
      0,
      1.135148,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.237397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332039,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793648,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.271891,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      '12024',
      '',
      NULL,
      NULL,
      '',
      '',
      0.913270,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


