set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '00310402',
      22.914228,
      10,
      '0033033',
      34.032531,
      5,
      1,
      2,
      '422032',
      4.079802,
      ' 9- 9-2002',
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.674326,
      0.644056,
      1,
      0,
      NULL,
      1.968001,
      3.332992,
      1,
      1,
      4,
      NULL,
      1.724727,
      0,
      7,
      0.222999,
      2.486124,
      1.215974,
      NULL,
      1.760102,
      2,
      NULL,
      7,
      NULL,
      3.236334,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.612443,
      NULL,
      NULL,
      6.431186,
      0.728456,
      7,
      2.293371,
      2,
      3.677484,
      2,
      0.351248,
      2,
      1,
      3,
      NULL,
      1.631164,
      0,
      NULL,
      NULL,
      1.146184,
      0.125345,
      3.525743,
      0,
      NULL,
      3,
      4.126245,
      0,
      1,
      NULL,
      1.340670,
      NULL,
      NULL,
      1.486209,
      NULL,
      NULL,
      0.105904,
      2.545771,
      1.298072,
      1.471505,
      0.383949,
      NULL,
      2.551253,
      1,
      NULL,
      3.757071,
      0,
      1,
      0,
      3,
      0,
      0.077632,
      0.518702,
      0,
      1.474949,
      NULL,
      0,
      1,
      2,
      3,
      3,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069287,
      1,
      2,
      3.645254,
      2,
      8,
      0,
      6.903336,
      3.180192,
      9,
      1.741330,
      7,
      3.986830,
      1.055379,
      3.345015,
      0.087654,
      3,
      0,
      1.064624,
      4.142444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869520,
      NULL,
      1,
      1,
      1.338351,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357827,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.293124,
      1.951707,
      1.320374,
      1,
      1.576608,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.840486,
      2.206551,
      3,
      2.287869,
      0.433415,
      1.685826,
      NULL,
      NULL,
      1.477905,
      3,
      1.830508,
      1,
      1,
      NULL,
      0.842763,
      0.366907,
      0,
      1,
      1.059842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075857,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.106689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.073455,
      0.244571,
      0,
      4.110992,
      '20100',
      '44430',
      NULL,
      1,
      '',
      NULL,
      '',
      0.507286,
      '',
      '',
      '',
      4,
      2.293693,
      3.381397,
      2,
      4,
      NULL,
      NULL,
      3,
      0);
commit;
end;
/


