set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '04341302',
      40.652251,
      3.435697,
      '0233024',
      15,
      6,
      NULL,
      0,
      '022141',
      NULL,
      ' 9-23-1990',
      28,
      19,
      NULL,
      NULL,
      NULL,
      1.079031,
      0.136813,
      1,
      NULL,
      0.526859,
      0.394332,
      1.968469,
      NULL,
      0.448807,
      7.051101,
      0.742530,
      NULL,
      0,
      7.013568,
      0,
      1.610066,
      0.407221,
      2,
      0,
      0,
      NULL,
      0.842297,
      NULL,
      1.250617,
      0.832736,
      0,
      NULL,
      NULL,
      NULL,
      1.462939,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.202238,
      1,
      NULL,
      NULL,
      1.548338,
      3,
      1.428616,
      1.257034,
      0.509588,
      NULL,
      1.459612,
      3.664366,
      0.124827,
      0.713353,
      1.124029,
      1,
      NULL,
      0.843728,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.859190,
      NULL,
      NULL,
      1.379437,
      3.271772,
      0,
      1.059955,
      5,
      NULL,
      1.452363,
      1.138092,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.800988,
      NULL,
      1.001003,
      1.595031,
      NULL,
      0,
      NULL,
      2.217369,
      0,
      5,
      4.478495,
      3.194452,
      1.662853,
      5.527862,
      1,
      NULL,
      2,
      2,
      0.714437,
      NULL,
      4,
      0,
      7,
      0,
      NULL,
      4,
      4,
      6,
      0,
      NULL,
      1.549787,
      NULL,
      5,
      2,
      NULL,
      1.870701,
      2,
      0.106821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.785141,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749784,
      NULL,
      NULL,
      NULL,
      NULL,
      7.916471,
      1.291827,
      1,
      0,
      1.041196,
      10,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592891,
      NULL,
      3.930124,
      NULL,
      NULL,
      0,
      3.840946,
      NULL,
      NULL,
      NULL,
      0.475567,
      3.434214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.720586,
      2.576399,
      0.433205,
      1,
      1.907066,
      NULL,
      0.676720,
      NULL,
      NULL,
      1.392411,
      1,
      1,
      1.331485,
      0,
      0.958987,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      '34123',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.633639,
      '',
      '',
      '',
      5.513987,
      3.718191,
      3,
      NULL,
      3.712854,
      3.990975,
      3,
      1,
      0);
commit;
end;
/


