set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '13442142',
      11,
      31,
      '4101231',
      70,
      3,
      1,
      1,
      '030344',
      NULL,
      '10-26-1991',
      29,
      2.713472,
      1.412566,
      NULL,
      3,
      NULL,
      0.263054,
      0,
      1,
      0,
      1,
      3.309967,
      NULL,
      0.378031,
      NULL,
      0.489244,
      2,
      1.994127,
      3.020122,
      NULL,
      1.014263,
      0.969423,
      3.632705,
      3,
      0.076482,
      3.795261,
      4.658202,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      3.576557,
      3,
      1.028084,
      2,
      NULL,
      0,
      2,
      1,
      0.807545,
      NULL,
      0.196315,
      NULL,
      0,
      0.807602,
      3,
      2.672934,
      0,
      NULL,
      NULL,
      0,
      3.734437,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1.744624,
      NULL,
      NULL,
      0.163772,
      3,
      0.302830,
      0.196638,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.555446,
      0,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      0.527024,
      0,
      NULL,
      1,
      1.473417,
      NULL,
      0,
      0,
      5.919355,
      3,
      1,
      5,
      1.590434,
      0,
      NULL,
      5.597785,
      0,
      4.047169,
      1,
      1,
      NULL,
      3.491428,
      NULL,
      7,
      NULL,
      8,
      2.594421,
      3.290339,
      3.434390,
      NULL,
      NULL,
      0.124296,
      0.793294,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038442,
      NULL,
      NULL,
      NULL,
      0.831872,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903874,
      5,
      0,
      0,
      1,
      0.117574,
      NULL,
      NULL,
      NULL,
      1.555035,
      1.772182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      1.882265,
      1.323930,
      1,
      0,
      0,
      1,
      1.793095,
      0.788489,
      1.663382,
      1.522647,
      0.181888,
      0.550649,
      1.009975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '24233',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.842645,
      '',
      NULL,
      '',
      1.702224,
      2.949335,
      NULL,
      5.801284,
      3,
      3,
      0,
      2,
      1.744256);
commit;
end;
/


