set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '21422410',
      28.537181,
      14.355823,
      '0434033',
      74,
      6,
      1,
      NULL,
      '134342',
      4,
      ' 9-19-1984',
      60.005422,
      56.440182,
      0.410712,
      NULL,
      0,
      1,
      NULL,
      1.869986,
      NULL,
      1.782354,
      0.323716,
      1,
      NULL,
      0.425802,
      0.101930,
      0,
      0.595392,
      0.270262,
      1.661694,
      1,
      0.465893,
      0.699069,
      NULL,
      0.619410,
      1,
      0,
      5.402064,
      1,
      1,
      1.865786,
      0,
      1.190010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.916203,
      NULL,
      1.031996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576891,
      0.711253,
      1.792465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.016421,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1.909791,
      1,
      0.072351,
      1,
      NULL,
      0,
      0,
      1,
      0.188036,
      3,
      0,
      2.917745,
      3.157979,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.290247,
      0.135882,
      1.830806,
      1,
      0,
      7.221207,
      6,
      6,
      6.047308,
      6,
      1,
      4.614580,
      1,
      NULL,
      3.672986,
      NULL,
      NULL,
      NULL,
      8.966382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130179,
      1.273765,
      1,
      0,
      1,
      0.269441,
      0.906415,
      1.729788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273875,
      0,
      2,
      0.452370,
      0.806016,
      NULL,
      0.526063,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.391090,
      0.258723,
      NULL,
      1,
      0,
      1.036246,
      1.611664,
      0.034849,
      1.562196,
      NULL,
      1.571433,
      1,
      1,
      0.678906,
      0.927205,
      1,
      0.066246,
      0.601383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992287,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.595359,
      1.105055,
      2,
      1.547388,
      NULL,
      '00430',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      3.251329,
      0,
      0.022629,
      4,
      0.119675,
      2.509272,
      3.037502,
      0.991026,
      1.226285);
commit;
end;
/


