set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '1240143',
      4.578624,
      1,
      2,
      3,
      '040434',
      1.874873,
      ' 4- 3-1976',
      47,
      NULL,
      1.187975,
      NULL,
      17,
      2.331124,
      0,
      NULL,
      1,
      0.615719,
      1.720289,
      0,
      NULL,
      1,
      NULL,
      1.550727,
      1.397965,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.421827,
      0,
      5,
      0,
      1.676879,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.405784,
      NULL,
      NULL,
      NULL,
      0,
      0.981955,
      2.781346,
      1,
      3.047523,
      0.045714,
      2,
      3.649871,
      2,
      0,
      0,
      NULL,
      0.955383,
      2,
      1,
      0,
      0.823664,
      5.957984,
      0,
      0,
      5.711205,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.966337,
      NULL,
      0.805836,
      0.893051,
      0,
      1,
      0.859001,
      0.182185,
      1,
      0.024538,
      0.013482,
      0,
      0,
      0,
      1.029859,
      1,
      0.127149,
      1,
      0.467748,
      NULL,
      1.605144,
      3.576021,
      0.727567,
      0,
      NULL,
      0,
      1.892204,
      1.952995,
      6,
      NULL,
      1,
      0.119709,
      1.073831,
      2,
      NULL,
      0.871656,
      NULL,
      0,
      NULL,
      5.983354,
      0.712895,
      0,
      1,
      NULL,
      4.452724,
      1.349164,
      NULL,
      3.023629,
      0.603711,
      NULL,
      NULL,
      2.806293,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      3.939460,
      2,
      NULL,
      2,
      0.735384,
      2.439059,
      0.612391,
      5,
      1,
      0.574214,
      1.957760,
      NULL,
      NULL,
      1.338056,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277975,
      1.613790,
      NULL,
      1.178420,
      0,
      0.728657,
      NULL,
      NULL,
      NULL,
      0,
      0.797469,
      1.696231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.619318,
      NULL,
      1.032783,
      1,
      NULL,
      3.066988,
      2.951094,
      1,
      1.528163,
      2.308124,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.028231,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34421',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.842141,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


