set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '4044200',
      10.716652,
      0,
      2,
      0,
      '200311',
      1.685146,
      ' 2-22-1981',
      37,
      NULL,
      1.892857,
      NULL,
      NULL,
      3,
      1.228542,
      0.079811,
      0.272898,
      0.101035,
      1.340833,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.814086,
      2,
      0.148970,
      1.854777,
      NULL,
      1,
      0.428710,
      0.434364,
      0.648632,
      1,
      5.108001,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.454357,
      NULL,
      NULL,
      7,
      2.441295,
      1,
      NULL,
      1.180644,
      NULL,
      0.292593,
      1,
      1.854039,
      1,
      1,
      2.559289,
      NULL,
      1.455681,
      1,
      2.917486,
      0.177741,
      1.410779,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.162177,
      0,
      0,
      0.664725,
      1.363059,
      0.255831,
      NULL,
      1,
      0.133124,
      NULL,
      0,
      1.819518,
      0,
      3.324566,
      0,
      NULL,
      0.759029,
      0,
      0.074274,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      0.840263,
      3,
      0,
      0,
      0.963710,
      NULL,
      NULL,
      NULL,
      1,
      3.684213,
      1,
      2.539894,
      NULL,
      NULL,
      1.175516,
      1.989629,
      1.315432,
      0,
      2.094266,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519732,
      NULL,
      1,
      0.604363,
      1,
      1,
      1.101830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.952325,
      1.502481,
      1,
      0.127525,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696871,
      3,
      0.560566,
      1.075275,
      1,
      2.293949,
      1.424404,
      NULL,
      NULL,
      1.650165,
      0.535662,
      0,
      NULL,
      0.183123,
      1.230056,
      1.989762,
      1.871556,
      1.489398,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '00104',
      '',
      '',
      0.857999,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


