set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '1010101',
      18.653695,
      3,
      3.706198,
      NULL,
      '031100',
      3,
      ' 5-24-2002',
      28.977061,
      NULL,
      0.759679,
      NULL,
      NULL,
      1,
      1.595053,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1.335704,
      1,
      0.870836,
      0,
      NULL,
      1.252093,
      1,
      0,
      0.498004,
      1,
      0.516430,
      1.017844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.384596,
      1,
      1,
      2,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.687458,
      NULL,
      NULL,
      NULL,
      2.228106,
      NULL,
      1.794512,
      0.727504,
      2,
      3.972815,
      5,
      1,
      NULL,
      NULL,
      0,
      1,
      5,
      0.199736,
      NULL,
      NULL,
      0.197519,
      NULL,
      NULL,
      NULL,
      0.827791,
      0.203088,
      0,
      0.725960,
      NULL,
      0.920907,
      0.123188,
      0.290999,
      0,
      1,
      NULL,
      1,
      1.105028,
      0.188345,
      1,
      0.213346,
      NULL,
      0.437469,
      NULL,
      1.260948,
      1.454511,
      3,
      0,
      1,
      1.519100,
      0.753967,
      0,
      0,
      1,
      3,
      1.367689,
      0.638841,
      0.088817,
      1,
      0.884584,
      0.721779,
      0,
      NULL,
      5.968926,
      0,
      NULL,
      NULL,
      4.576169,
      0.211323,
      0,
      0.590570,
      0.629539,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133558,
      0,
      0,
      1,
      NULL,
      0,
      1.337449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590132,
      1,
      0.584455,
      0.507626,
      0,
      NULL,
      1.043108,
      NULL,
      NULL,
      NULL,
      0,
      0.903930,
      1.649551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.262670,
      2,
      1,
      NULL,
      NULL,
      1,
      0.826135,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047893,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23014',
      '',
      '',
      0,
      '',
      '',
      '',
      0.301356,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


