set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '2313314',
      42,
      0,
      0.736296,
      2,
      '230111',
      2,
      NULL,
      16,
      NULL,
      0,
      NULL,
      NULL,
      0.167720,
      NULL,
      0.583853,
      2.259380,
      0,
      NULL,
      0.571477,
      NULL,
      1.755173,
      NULL,
      1.317629,
      1.172687,
      1,
      0,
      1.920846,
      0,
      0,
      0.944572,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081565,
      1,
      NULL,
      1,
      0.031880,
      NULL,
      NULL,
      0,
      3,
      1.329592,
      1.889368,
      NULL,
      2,
      3.830105,
      1,
      3.129969,
      1,
      0.737886,
      0.292844,
      0,
      1.005465,
      NULL,
      5,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.410282,
      NULL,
      NULL,
      1.296412,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1.403783,
      NULL,
      0,
      NULL,
      1,
      0.066251,
      1.748325,
      1.918296,
      1,
      0,
      0.030936,
      1.291583,
      NULL,
      NULL,
      0.603920,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.834994,
      1,
      NULL,
      0,
      0.756765,
      0.107804,
      1,
      0.402605,
      1.358068,
      NULL,
      1,
      4.923721,
      0.053516,
      0,
      1.524768,
      0.802384,
      2,
      0,
      1.667940,
      1.615228,
      1,
      1.721020,
      0.791701,
      6,
      0.884563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668182,
      0.295462,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.220118,
      0.548867,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.894809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392790,
      0,
      1.120876,
      NULL,
      0,
      NULL,
      1.565690,
      1,
      0.230477,
      1.386045,
      NULL,
      NULL,
      1,
      1.865679,
      0,
      0,
      NULL,
      0.356797,
      0,
      1.667379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '32040',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


