set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '1200400',
      NULL,
      2,
      NULL,
      0,
      '034030',
      1.051184,
      NULL,
      33,
      NULL,
      1.013932,
      NULL,
      0,
      3.958080,
      1.483417,
      1.359359,
      1.013106,
      NULL,
      0,
      0.505311,
      NULL,
      0.244135,
      0.206751,
      NULL,
      1.053210,
      NULL,
      0,
      1.578479,
      NULL,
      1.879821,
      0.962073,
      0.557347,
      1.733275,
      0.409258,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052369,
      NULL,
      1,
      0.719142,
      1.778738,
      0.364045,
      0.234469,
      0.940295,
      3,
      2,
      1,
      1,
      0.773441,
      2.563630,
      0.675838,
      0.367193,
      3.933172,
      1.801821,
      NULL,
      0.368658,
      2.764559,
      NULL,
      2,
      2,
      1.582120,
      NULL,
      NULL,
      1.887685,
      NULL,
      NULL,
      1.374199,
      0.525247,
      0.065252,
      NULL,
      1.615851,
      2,
      NULL,
      1.408448,
      0,
      1,
      0,
      1,
      1,
      0,
      1.915581,
      0.641118,
      1.997246,
      1.741382,
      0.254117,
      NULL,
      1,
      1,
      0.364002,
      0,
      1.467642,
      1,
      0.359538,
      NULL,
      1.771831,
      1,
      0,
      1,
      NULL,
      1.456975,
      NULL,
      1,
      1.475033,
      4,
      NULL,
      4,
      7.710374,
      0.389779,
      1.700360,
      9,
      6.957198,
      1,
      2,
      3.540841,
      0.632025,
      NULL,
      NULL,
      3.784609,
      1.541910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572898,
      0,
      1,
      0,
      0.981493,
      0.132718,
      0,
      0.747764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.945563,
      0.921453,
      0.038192,
      1,
      0.280344,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.288337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563070,
      0,
      NULL,
      0.968477,
      1.412839,
      NULL,
      0.744350,
      2.276626,
      NULL,
      3,
      0.150958,
      0,
      0.303695,
      0,
      1.373689,
      NULL,
      0.570029,
      0.100456,
      NULL,
      1.940260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      NULL,
      0.262530,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


