set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '2044143',
      17.262190,
      NULL,
      1.628517,
      0,
      NULL,
      NULL,
      ' 3- 1-1999',
      27,
      NULL,
      0.597846,
      NULL,
      8,
      0,
      NULL,
      1.232235,
      0.655740,
      1.231082,
      0,
      0.140566,
      1,
      1.762338,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0.049074,
      0,
      1,
      0.035651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.269649,
      3,
      NULL,
      1,
      3.391404,
      2,
      3,
      NULL,
      2,
      0,
      1.496312,
      2.182598,
      1,
      0,
      NULL,
      0,
      NULL,
      0.648529,
      0,
      0,
      4,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145360,
      NULL,
      NULL,
      0.390394,
      1,
      1.735206,
      0.057403,
      1.774487,
      1,
      0.034728,
      0,
      NULL,
      0.098841,
      NULL,
      0.730837,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.448421,
      0,
      0.334131,
      7,
      1,
      1.725393,
      1.998427,
      NULL,
      3.606674,
      1,
      1,
      NULL,
      NULL,
      0.281789,
      NULL,
      NULL,
      5,
      NULL,
      5,
      0,
      1.357921,
      0,
      NULL,
      3,
      1.013898,
      15.252512,
      1.524667,
      3.006748,
      1,
      1.231596,
      9.278098,
      1.010100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045075,
      1,
      1,
      0,
      NULL,
      0.128314,
      0.920990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.842431,
      NULL,
      1.528254,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.005281,
      0.443397,
      1.756750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082975,
      0,
      1,
      1,
      NULL,
      1,
      1.975639,
      1,
      1.905615,
      2.809366,
      0,
      NULL,
      NULL,
      1.726840,
      0.841065,
      1.242802,
      1.189632,
      NULL,
      1.324643,
      0.472061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21320',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


