set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '1400201',
      37,
      3,
      2,
      0,
      '004414',
      NULL,
      ' 9-20-1991',
      44.709099,
      NULL,
      1.161938,
      NULL,
      1.083842,
      3.220558,
      1,
      1,
      NULL,
      1.525087,
      0,
      0,
      NULL,
      NULL,
      1.079239,
      0,
      1,
      1.872376,
      0.625195,
      0,
      0.345396,
      1,
      NULL,
      0,
      NULL,
      0.620154,
      1.656496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.855670,
      0,
      0,
      1.546529,
      0.576625,
      2.257987,
      1,
      NULL,
      NULL,
      3,
      1.544854,
      NULL,
      NULL,
      2,
      NULL,
      0.909551,
      1,
      1,
      0,
      0.676501,
      0.953029,
      1,
      0,
      3.122270,
      1.622006,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.664351,
      1.233917,
      1.946054,
      1.783213,
      1.792641,
      3,
      0,
      NULL,
      1.254489,
      NULL,
      1.918858,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      3.560408,
      0.447715,
      1,
      0,
      1.148777,
      5.975140,
      NULL,
      NULL,
      NULL,
      0,
      0.063443,
      0,
      NULL,
      1,
      0.777646,
      0,
      NULL,
      5.970754,
      NULL,
      5.060420,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      5.650980,
      1.238743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410833,
      NULL,
      1,
      0,
      1,
      1,
      1.197511,
      1.955632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533435,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.638533,
      0.074749,
      NULL,
      0.279030,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.994287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.698790,
      1.313385,
      0,
      2,
      NULL,
      0.005466,
      0,
      3,
      1,
      0.179401,
      0,
      NULL,
      1.718636,
      1.483433,
      0.095993,
      0.360836,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.105623,
      '44303',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.525505,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


