set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '2320041',
      NULL,
      2,
      2,
      NULL,
      NULL,
      2,
      ' 5-21-1996',
      40,
      NULL,
      0,
      NULL,
      9.262061,
      NULL,
      1,
      1,
      NULL,
      1,
      1.149197,
      0,
      NULL,
      1,
      0.556196,
      1.723652,
      0,
      1.908509,
      NULL,
      1.881051,
      1,
      0.266831,
      1.671233,
      0.213628,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      5.014602,
      1,
      0,
      0.137998,
      1,
      1,
      1.309712,
      NULL,
      1,
      0,
      1,
      NULL,
      0.363523,
      NULL,
      0.950919,
      0.876752,
      0.213036,
      1.334581,
      0,
      NULL,
      3,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.211959,
      1,
      1,
      0.147222,
      0,
      2,
      1.451030,
      1.172883,
      1.364062,
      1.452970,
      NULL,
      0.555350,
      5,
      0.602597,
      1.109109,
      1,
      0,
      0.241356,
      NULL,
      1.663311,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      0.597150,
      0,
      NULL,
      1.661589,
      1,
      1.207376,
      0,
      NULL,
      1,
      5,
      NULL,
      2,
      NULL,
      5,
      NULL,
      2.994955,
      6,
      1,
      3.172038,
      4.830248,
      NULL,
      1.454988,
      NULL,
      NULL,
      2,
      1.023220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427111,
      NULL,
      NULL,
      1,
      1.178646,
      1.258841,
      1,
      0.824311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603710,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751521,
      0.637842,
      NULL,
      NULL,
      NULL,
      0,
      1.432660,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.039445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881614,
      NULL,
      1.680592,
      1.957289,
      1.339378,
      NULL,
      0.684206,
      NULL,
      0.328491,
      3,
      NULL,
      0.050158,
      NULL,
      0.980442,
      1.121101,
      0.095708,
      1.957401,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


