set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '4203213',
      3,
      0,
      NULL,
      2,
      NULL,
      0.544212,
      ' 5-20-1985',
      34.714973,
      NULL,
      1.392407,
      NULL,
      1.619072,
      1.675623,
      0,
      0,
      1,
      0,
      0.958135,
      0.342971,
      0,
      1.460638,
      0,
      0.876406,
      NULL,
      1.373964,
      0,
      0,
      0.213481,
      0.995901,
      1,
      NULL,
      3.910541,
      NULL,
      0.599682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.171970,
      NULL,
      1.649915,
      NULL,
      0,
      0,
      1.072207,
      2,
      1.912633,
      3.396118,
      1.492684,
      1,
      NULL,
      0.252598,
      1,
      NULL,
      0,
      1.335651,
      1.587309,
      0.958284,
      1.329373,
      NULL,
      1.622674,
      1,
      2,
      1.445971,
      1,
      NULL,
      NULL,
      1.594807,
      NULL,
      NULL,
      0.861282,
      1,
      1,
      NULL,
      1.810393,
      1.176633,
      5.810242,
      1.891037,
      0,
      3,
      NULL,
      1.836520,
      0.291478,
      NULL,
      0,
      NULL,
      0.458073,
      0.715102,
      NULL,
      NULL,
      NULL,
      1.979268,
      0,
      3.553738,
      NULL,
      1.259572,
      1.055487,
      1.847974,
      0,
      1.351830,
      NULL,
      NULL,
      1,
      1.197026,
      2,
      NULL,
      1,
      NULL,
      5.741315,
      NULL,
      NULL,
      0,
      NULL,
      5.952057,
      NULL,
      5.849897,
      NULL,
      3.312994,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.089119,
      1,
      0,
      0.237977,
      1,
      NULL,
      0.803529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437424,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487042,
      1,
      1.134843,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.813699,
      NULL,
      NULL,
      NULL,
      1.690991,
      NULL,
      NULL,
      NULL,
      0.904468,
      1.292141,
      1.951473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536235,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.181809,
      0.837918,
      0.712105,
      1,
      0,
      NULL,
      NULL,
      1.839549,
      0.814345,
      1,
      0,
      1.122376,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '23223',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.371717,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


