set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '1304304',
      55,
      2,
      3,
      NULL,
      '002010',
      2,
      ' 1-20-1989',
      29.597857,
      NULL,
      NULL,
      NULL,
      8.863713,
      0.642170,
      0.613131,
      NULL,
      1.671040,
      NULL,
      NULL,
      0,
      NULL,
      1.643422,
      NULL,
      1.812685,
      0.884028,
      1,
      1.877029,
      0,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      2.692376,
      0,
      1,
      NULL,
      0.770055,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.541380,
      1,
      NULL,
      NULL,
      NULL,
      3.507242,
      2.810585,
      NULL,
      1.179424,
      0.283624,
      3,
      1,
      1,
      3.159283,
      1.532173,
      NULL,
      1,
      2,
      NULL,
      1,
      4,
      2.501163,
      1,
      2,
      2.650863,
      1,
      NULL,
      NULL,
      0.496089,
      NULL,
      NULL,
      0,
      1,
      1,
      1.982686,
      0,
      1,
      1,
      1,
      0,
      0.632214,
      1,
      1.023987,
      1,
      1,
      0.877108,
      1,
      1,
      NULL,
      0.664042,
      NULL,
      1.431951,
      1,
      1.816780,
      3,
      1.457590,
      3,
      5.097097,
      1,
      0,
      0.866848,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.567013,
      3.743565,
      NULL,
      0.893241,
      0.395030,
      0,
      NULL,
      NULL,
      1,
      1.248079,
      1.678886,
      0.716794,
      NULL,
      NULL,
      7,
      0.536312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142302,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165965,
      0.745618,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0.251983,
      NULL,
      0,
      0.785164,
      NULL,
      NULL,
      NULL,
      1,
      1.217782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090175,
      0,
      0,
      1.955681,
      3,
      NULL,
      NULL,
      1.811087,
      0,
      1.578777,
      1.716996,
      0,
      NULL,
      NULL,
      0.189663,
      1,
      1.655416,
      NULL,
      1.058958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941924,
      '23202',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.965624,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


