set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '2024042',
      NULL,
      NULL,
      2.925854,
      0,
      NULL,
      0.369492,
      ' 2-20-2000',
      34.200728,
      NULL,
      1.135927,
      NULL,
      5,
      1,
      0.477796,
      0.270083,
      1,
      2.764373,
      0,
      0,
      1.689200,
      0.414051,
      0,
      1.484184,
      1.480758,
      0,
      0,
      0.389522,
      NULL,
      1.038616,
      1.192516,
      0.832739,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736244,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      2.255183,
      NULL,
      NULL,
      1.976511,
      0,
      NULL,
      0.778441,
      3.363750,
      3.895496,
      NULL,
      2.238749,
      0.055643,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      2.705550,
      NULL,
      NULL,
      3,
      1,
      2,
      3.490906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.707821,
      2,
      2.189751,
      2.187905,
      0.155054,
      0.792433,
      NULL,
      1.398383,
      0,
      1,
      0,
      0.125011,
      1.626031,
      0.243884,
      NULL,
      0,
      NULL,
      1,
      0.892695,
      1.534133,
      4.717198,
      3,
      0.955877,
      2.350649,
      1.468113,
      1,
      6,
      NULL,
      0,
      0,
      1.045843,
      5.601998,
      0.303785,
      0,
      1.797411,
      7.919632,
      0.766446,
      NULL,
      NULL,
      1,
      4,
      2,
      2,
      8.705367,
      3,
      0.377015,
      0,
      1,
      5.937728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004767,
      NULL,
      NULL,
      1,
      0,
      1.685306,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237820,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.597708,
      NULL,
      NULL,
      1.374970,
      9.982679,
      0.725795,
      0,
      NULL,
      NULL,
      NULL,
      0.494395,
      1.875898,
      0.617321,
      0.788492,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.282573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896668,
      1,
      1.694924,
      1.376249,
      0,
      1,
      NULL,
      1.246705,
      1.389984,
      NULL,
      1.056038,
      1,
      NULL,
      0.066217,
      1.931367,
      1,
      0.975745,
      0.953425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.516093,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


