set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      0,
      0.663700,
      NULL,
      '043324',
      0,
      ' 9- 6-1979',
      15,
      NULL,
      0.321209,
      NULL,
      1.022709,
      NULL,
      1,
      1.097411,
      NULL,
      1,
      1,
      0,
      1.763786,
      0.554739,
      0.867093,
      1.694720,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0.150859,
      0.526276,
      1,
      1.272707,
      0.003105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.220697,
      0.235823,
      4,
      3.401261,
      1.835999,
      0.782766,
      NULL,
      1.458108,
      0,
      3,
      2.534231,
      0.606760,
      0.804398,
      3,
      1,
      0.649489,
      NULL,
      0,
      0.530973,
      0.132885,
      0,
      0.086644,
      5,
      NULL,
      2,
      2.422069,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.347823,
      NULL,
      1,
      1.607678,
      1.298780,
      0.233664,
      NULL,
      5.786558,
      NULL,
      NULL,
      NULL,
      0.979182,
      0,
      1.050742,
      NULL,
      1.641069,
      NULL,
      NULL,
      NULL,
      0,
      0.552833,
      0,
      1,
      1.315988,
      3.587055,
      0,
      0,
      1.626620,
      4,
      0.013727,
      1.706756,
      1.613749,
      1,
      0.994684,
      1,
      NULL,
      5.915838,
      0,
      7,
      1.206029,
      2.585084,
      5.788948,
      NULL,
      1,
      5.805149,
      4.590263,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953123,
      0.193802,
      1,
      1,
      1.841978,
      1.940588,
      1.967545,
      1.954286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.981412,
      0.120715,
      NULL,
      NULL,
      1.256153,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.930892,
      0.131984,
      0.703204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.332980,
      1,
      1,
      0.385805,
      2.635839,
      0.553193,
      NULL,
      1.654081,
      0.956933,
      NULL,
      1.715682,
      0.986996,
      1.661319,
      0.078133,
      1,
      0.404215,
      0.286535,
      1.436675,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.813353,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.166744,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


