set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '2022314',
      56.982965,
      4,
      3.718506,
      3,
      NULL,
      2,
      ' 8-21-1978',
      27,
      NULL,
      1.246950,
      NULL,
      2.157435,
      NULL,
      0.671138,
      1.789919,
      NULL,
      0.405952,
      1,
      1,
      3.770271,
      0,
      1,
      1.430997,
      1,
      0.295672,
      1.898751,
      1.464720,
      NULL,
      0.833805,
      0.111582,
      1.161325,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869064,
      1,
      0.227130,
      1,
      0.044178,
      3,
      1,
      NULL,
      0,
      1,
      0.834148,
      3.506536,
      0.199152,
      1.191718,
      0,
      NULL,
      3.171324,
      0,
      1.207798,
      1.310948,
      4,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.692233,
      NULL,
      1,
      0,
      2,
      4,
      NULL,
      NULL,
      0.481354,
      NULL,
      NULL,
      1,
      0,
      2.374323,
      0.424020,
      NULL,
      1.730507,
      1.002773,
      0.086602,
      NULL,
      1.055251,
      0,
      1.956253,
      1,
      5.432324,
      0.711989,
      3.448599,
      0,
      0.512284,
      2.757805,
      7.501847,
      1,
      0,
      1,
      1.029391,
      1,
      0,
      NULL,
      7.120472,
      4,
      3.483343,
      0.797461,
      3.808654,
      NULL,
      0,
      1,
      NULL,
      0,
      1.720020,
      NULL,
      NULL,
      7.106394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771085,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3.883264,
      1.034088,
      NULL,
      1,
      3.075920,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928057,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427122,
      1.771065,
      0,
      NULL,
      NULL,
      3,
      1,
      0.532056,
      1,
      NULL,
      0.760845,
      0.933349,
      1.196419,
      NULL,
      1.108213,
      1.870316,
      NULL,
      1.272072,
      0.412722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      '',
      1.369314,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


