set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '4341040',
      164.389646,
      NULL,
      2.188381,
      NULL,
      '123340',
      3,
      ' 3-12-2000',
      50.759615,
      NULL,
      1.377785,
      NULL,
      NULL,
      1,
      1.711560,
      NULL,
      1,
      0.058911,
      0.988259,
      NULL,
      3.490548,
      1,
      0.618957,
      1.760673,
      NULL,
      0,
      0,
      0.645293,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.774635,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.491607,
      0.863872,
      0,
      1,
      2.969230,
      NULL,
      NULL,
      1.053107,
      NULL,
      1.217262,
      0,
      0.071074,
      NULL,
      3.735236,
      NULL,
      NULL,
      1,
      2.807554,
      0.564239,
      1.815194,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.607166,
      0,
      0,
      1.732662,
      1.214884,
      1,
      NULL,
      1.209046,
      NULL,
      1.480650,
      1,
      0,
      0.238924,
      NULL,
      1.962090,
      1,
      0.195856,
      NULL,
      NULL,
      0.629802,
      1.087318,
      1.036060,
      1,
      0.940356,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909509,
      1.294201,
      0,
      0.072230,
      1.991672,
      2.649387,
      2.831241,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.570111,
      5,
      1.149433,
      0.924963,
      NULL,
      NULL,
      3.371120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043313,
      1,
      0,
      1,
      NULL,
      0.881227,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.484883,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065092,
      NULL,
      1.228749,
      0.139271,
      1.692681,
      2,
      1.365443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273808,
      1.059737,
      NULL,
      0.473732,
      0,
      1.738258,
      0.416173,
      1,
      0.772286,
      0.381200,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1.323839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.922786,
      '01241',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


