set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '40',
      18,
      0,
      '3144331',
      86.377034,
      0,
      0.305665,
      1,
      '320103',
      1,
      ' 2- 9-1985',
      37,
      NULL,
      1,
      NULL,
      7,
      1.553440,
      2,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0.532615,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.146863,
      NULL,
      0,
      NULL,
      0.554109,
      0.651242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.005129,
      3,
      0.551600,
      1.353246,
      1.042095,
      0.461066,
      1,
      2,
      1.699849,
      1,
      0.415260,
      3.843703,
      1,
      0,
      1.447553,
      0,
      1.045945,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.051650,
      0.652669,
      5.215457,
      NULL,
      2.137495,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0.658028,
      5,
      0,
      1,
      0.526727,
      0,
      0.138598,
      NULL,
      NULL,
      0.593536,
      1.982531,
      0,
      0,
      NULL,
      1.717998,
      NULL,
      2.412583,
      0.322088,
      NULL,
      0,
      1.958258,
      0,
      NULL,
      0,
      1,
      0.764612,
      3,
      4.326197,
      3,
      1.617230,
      0.068646,
      4.284543,
      NULL,
      0.752141,
      5,
      4,
      0.103633,
      0,
      0,
      3.942107,
      0.934205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743344,
      NULL,
      1,
      1,
      0.761383,
      0,
      0.414099,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.241880,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.405379,
      NULL,
      1.383739,
      0,
      NULL,
      1.499864,
      NULL,
      NULL,
      NULL,
      0.572391,
      0.026473,
      0.938441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.099671,
      1.867998,
      1,
      0.142053,
      NULL,
      NULL,
      NULL,
      0.718086,
      3,
      0,
      1,
      1,
      0.312464,
      1,
      NULL,
      1.355239,
      1.365636,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20334',
      '',
      '',
      0.195415,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


