set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      '44',
      15,
      NULL,
      '1042000',
      162.451782,
      1,
      NULL,
      0,
      NULL,
      NULL,
      '11- 9-1991',
      8.357761,
      NULL,
      0.022551,
      NULL,
      NULL,
      0.263207,
      3,
      NULL,
      NULL,
      1,
      0.100408,
      NULL,
      1.655291,
      1,
      0,
      0,
      1.613694,
      1.259441,
      1.337866,
      0.737807,
      1.615140,
      NULL,
      1.325687,
      0,
      0.721157,
      0,
      0.972050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      0.412075,
      NULL,
      1,
      0.952032,
      2,
      NULL,
      1,
      1,
      NULL,
      0.519294,
      0,
      0.200333,
      NULL,
      0.960563,
      1.008965,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.638606,
      1.604619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155731,
      1,
      1,
      0,
      0.545708,
      4.999878,
      1.382791,
      0,
      NULL,
      1,
      1.851044,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.963091,
      1.082883,
      0.075418,
      NULL,
      0,
      0,
      1.118308,
      1,
      0,
      0,
      1,
      3.542288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      2.723882,
      2.328687,
      1.567403,
      0,
      1,
      NULL,
      NULL,
      3.952865,
      4,
      2,
      4,
      1,
      0,
      1.913389,
      3.430537,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.901453,
      1.156554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.851419,
      1,
      2.471071,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904819,
      1.865328,
      1.030470,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.338274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.991213,
      1,
      1.247738,
      2,
      1,
      0.867307,
      1,
      NULL,
      0,
      0.688130,
      0,
      0.338712,
      NULL,
      0.210775,
      1.634927,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '43121',
      '',
      '',
      0.263393,
      '',
      NULL,
      '',
      0.018609,
      NULL,
      '',
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


