set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      '40',
      34.711444,
      NULL,
      '3242103',
      135.658564,
      0,
      1,
      3,
      '000333',
      5,
      ' 6-12-2003',
      NULL,
      58,
      1,
      NULL,
      11,
      NULL,
      1,
      1,
      0.914254,
      2.581482,
      0,
      1.258398,
      1.095094,
      1.540422,
      1.501368,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1.247131,
      NULL,
      1.528729,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.878429,
      0.560760,
      NULL,
      1,
      NULL,
      3.191356,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.232502,
      NULL,
      1,
      3.688012,
      0.147248,
      0,
      1.520138,
      NULL,
      0.788617,
      1,
      1.606270,
      NULL,
      1,
      0.601144,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.137842,
      NULL,
      3,
      NULL,
      NULL,
      2,
      5.677263,
      0,
      1,
      1,
      NULL,
      0.478085,
      1,
      4.205253,
      1.400677,
      0.173676,
      0,
      NULL,
      0.987168,
      NULL,
      1,
      0.713943,
      1.770319,
      NULL,
      1,
      0.367597,
      0.953069,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      2,
      1,
      1,
      NULL,
      1.850480,
      2.680679,
      1.497760,
      0.888225,
      2,
      6,
      NULL,
      4.632525,
      10,
      4.109873,
      0,
      0.337013,
      1,
      NULL,
      1.878086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047613,
      NULL,
      0,
      0,
      NULL,
      1.401105,
      1.118073,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021607,
      0,
      1.896257,
      1.048001,
      3.395891,
      1,
      3,
      NULL,
      1.921713,
      0,
      0.727253,
      NULL,
      NULL,
      0.942308,
      1,
      NULL,
      1.746504,
      1.667017,
      0.383129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.997194,
      '42034',
      '',
      NULL,
      1.526435,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


