set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      '42',
      26,
      5,
      '0102440',
      NULL,
      6,
      1.095932,
      2,
      '302204',
      3,
      NULL,
      NULL,
      31,
      1,
      NULL,
      NULL,
      1.143014,
      3.801523,
      1,
      1.623680,
      NULL,
      0.165199,
      NULL,
      3,
      0,
      0.646857,
      NULL,
      0.303350,
      0.154556,
      0.088384,
      1.052917,
      NULL,
      0,
      1.095217,
      1,
      0.297313,
      NULL,
      2.438669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.244007,
      1.871808,
      1,
      NULL,
      0,
      1.896638,
      NULL,
      1.483158,
      NULL,
      2,
      3,
      0.239342,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1.838159,
      0.118425,
      5.804276,
      1,
      2,
      0.329487,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.270716,
      1.338242,
      NULL,
      0.683572,
      NULL,
      1,
      0.413027,
      0,
      0.617049,
      1.446870,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.976855,
      0.992961,
      1,
      NULL,
      0.446695,
      0,
      1.490065,
      0.654611,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763561,
      0.735560,
      NULL,
      1.446368,
      0.341303,
      NULL,
      7,
      NULL,
      NULL,
      0,
      5,
      NULL,
      4.506983,
      5,
      1,
      2,
      1,
      NULL,
      NULL,
      0.506669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991176,
      0.354227,
      NULL,
      1,
      0.629577,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282182,
      1.579903,
      2,
      1.893935,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345738,
      2.628470,
      NULL,
      NULL,
      NULL,
      0.969998,
      1.135754,
      1.190886,
      0,
      3,
      0,
      1.201410,
      1.627849,
      0.904024,
      1.950157,
      0,
      1.942220,
      1.748437,
      1.253548,
      0.038390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.324404,
      '21043',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      0.668588,
      '',
      NULL,
      '',
      1.007351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


