set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      '32',
      10,
      45.062435,
      '4210023',
      80,
      NULL,
      2,
      1,
      '233223',
      0.875070,
      ' 0-27-1976',
      NULL,
      25,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      2.320694,
      1.744597,
      1,
      1,
      1.635668,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1.587944,
      1,
      1.571451,
      1.071297,
      0.382145,
      0,
      1.224764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.819636,
      0.312230,
      2,
      1,
      0,
      0,
      3,
      1,
      1,
      NULL,
      2,
      1.087405,
      2.120142,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.107865,
      1,
      5,
      0,
      NULL,
      0,
      0.271375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478357,
      0,
      1,
      0,
      1.198011,
      1,
      0,
      1.150997,
      0,
      NULL,
      NULL,
      0.589286,
      0.163685,
      2.540496,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.311151,
      1,
      1,
      0.340796,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.371735,
      5.024023,
      1.784750,
      1,
      2,
      1,
      1,
      3.341230,
      3,
      1.195442,
      1.080974,
      0,
      0,
      0.369068,
      1,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0.470418,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868966,
      NULL,
      1,
      0,
      1,
      1.817805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052075,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.041413,
      0.324974,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951991,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.695254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.716127,
      0.048830,
      0.647345,
      1.902120,
      1,
      0.171783,
      1,
      3,
      NULL,
      NULL,
      0.146632,
      1,
      1,
      NULL,
      1.250411,
      0.341463,
      0.744786,
      0.690270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '33414',
      '32403',
      NULL,
      1.514705,
      '',
      NULL,
      '',
      1.443417,
      '',
      '',
      NULL,
      4.212352,
      0,
      3,
      3,
      3,
      NULL,
      0,
      0,
      1.468817);
commit;
end;
/


