set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      NULL,
      NULL,
      9.668893,
      '3113142',
      NULL,
      6,
      1.961631,
      1,
      '024310',
      1.493282,
      ' 4-24-2000',
      16.519605,
      33.556944,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.381212,
      1.299904,
      1,
      1,
      1.150848,
      0.658324,
      1.106113,
      1.035064,
      0.255667,
      0.092021,
      NULL,
      1.843042,
      0,
      NULL,
      0.431557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.306864,
      0,
      1.799212,
      NULL,
      NULL,
      0.039718,
      0,
      1,
      1.354111,
      2.008283,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.495792,
      0.867920,
      1,
      NULL,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.336557,
      5.781044,
      1.975940,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4,
      1,
      0.660098,
      1.426280,
      0.793776,
      1.018266,
      NULL,
      NULL,
      0.829624,
      0,
      1,
      0.361330,
      1,
      0,
      1,
      4,
      3,
      1,
      5,
      NULL,
      0,
      4,
      NULL,
      1.734009,
      5.675742,
      4,
      2,
      1.985709,
      1,
      1,
      0.120943,
      5.749887,
      5,
      0.782600,
      1.349133,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0.932140,
      0.232116,
      0.100305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934422,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202999,
      0.616023,
      1.639807,
      4,
      4.418749,
      NULL,
      1.708204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.259756,
      1.703302,
      1.345398,
      0,
      0.891740,
      NULL,
      NULL,
      1,
      2.751148,
      1,
      1,
      0,
      0,
      1,
      1.905834,
      0.775690,
      1.350261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.162902,
      '24433',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      1.424444,
      2,
      3,
      2,
      NULL,
      2.398941,
      2.977677,
      1);
commit;
end;
/


