set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      '42012023',
      35,
      14.033010,
      '4201243',
      270,
      1,
      NULL,
      2,
      '412211',
      5,
      ' 0- 9-1977',
      41.717250,
      NULL,
      0.078453,
      NULL,
      NULL,
      NULL,
      1,
      1.649331,
      1.006481,
      0,
      0.927058,
      NULL,
      0,
      1.316729,
      2,
      1,
      0.394750,
      1,
      NULL,
      NULL,
      0.124020,
      0,
      0.847114,
      NULL,
      0.100841,
      NULL,
      2,
      NULL,
      3,
      1.664131,
      1.710552,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542397,
      0,
      0.631084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.955981,
      0.695294,
      NULL,
      0.972848,
      NULL,
      NULL,
      NULL,
      1,
      0.533098,
      0.598340,
      1.636779,
      1,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.024040,
      1.203904,
      0,
      0,
      NULL,
      0.049218,
      1.691230,
      1,
      1.775110,
      NULL,
      2.950861,
      3,
      0.863089,
      NULL,
      0,
      0,
      0,
      3.865302,
      5.538067,
      4.702193,
      1.184855,
      3.464746,
      NULL,
      2,
      NULL,
      0,
      0.217706,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.894617,
      0,
      NULL,
      NULL,
      0.813147,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950432,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.896524,
      1.065759,
      0.697138,
      4.077230,
      0,
      1.083937,
      NULL,
      NULL,
      NULL,
      1.377945,
      0.339440,
      0.932377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073129,
      NULL,
      0.041913,
      0,
      2.445489,
      0,
      0,
      3,
      1,
      1,
      0,
      1.526802,
      NULL,
      1.855056,
      0,
      1.944739,
      1.736358,
      1,
      1.909298,
      1.475946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466251,
      '12142',
      '04323',
      '',
      1.823601,
      NULL,
      NULL,
      NULL,
      3.053721,
      '3324',
      NULL,
      '00130',
      3,
      1.706751,
      1.719022,
      3,
      0,
      3,
      2,
      1,
      NULL);
commit;
end;
/


