set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '34123243',
      11.743616,
      37.549951,
      NULL,
      93,
      0,
      0.710273,
      0,
      '111134',
      4,
      ' 8- 6-1996',
      46,
      53.669611,
      NULL,
      NULL,
      12,
      NULL,
      0,
      0,
      0.867384,
      3,
      0.328862,
      0,
      2.051521,
      1.449825,
      0,
      NULL,
      4.495644,
      2,
      2.424976,
      0,
      6,
      1.968687,
      NULL,
      0.883043,
      1.739288,
      0,
      3,
      0,
      0,
      1,
      2,
      0.546485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.323556,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.373960,
      0,
      2,
      1.263600,
      0,
      1,
      0.293398,
      0.131472,
      1.055707,
      NULL,
      1,
      0,
      1.004232,
      NULL,
      NULL,
      NULL,
      0.805911,
      NULL,
      NULL,
      0.413398,
      0,
      NULL,
      0.972244,
      3,
      NULL,
      3.529325,
      0,
      1.375935,
      NULL,
      NULL,
      0,
      0.274293,
      4,
      NULL,
      NULL,
      1.855907,
      1.236357,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.541009,
      0.927380,
      0.247221,
      0.498973,
      0.173146,
      0.857213,
      5.448766,
      1,
      NULL,
      1.046962,
      1.157113,
      3.197357,
      0,
      1.456040,
      4,
      3,
      NULL,
      2,
      9.765151,
      0,
      7.214562,
      2.153264,
      4,
      1.338624,
      3,
      0,
      NULL,
      NULL,
      4.311402,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170369,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047517,
      1,
      1,
      NULL,
      0,
      NULL,
      0.788144,
      NULL,
      NULL,
      NULL,
      1.146953,
      0.788567,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.916008,
      1.167800,
      1,
      1.263027,
      NULL,
      0,
      3,
      0.718806,
      1,
      1.209236,
      0.610728,
      1,
      0,
      1.367667,
      1.833434,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '43332',
      '02400',
      '',
      1.281453,
      '',
      '',
      '',
      0.747748,
      '2410',
      '3130',
      '32412',
      1,
      0.349634,
      NULL,
      0,
      0.555836,
      1.765122,
      NULL,
      NULL,
      2);
commit;
end;
/


