set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '42110034',
      NULL,
      30.506272,
      '0130221',
      353,
      NULL,
      0.364963,
      0,
      '014030',
      0,
      ' 0-12-2002',
      5,
      54.006189,
      1,
      NULL,
      12,
      2.195778,
      1,
      1.899242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804119,
      4,
      0,
      5.012023,
      4.753127,
      0,
      0,
      4,
      NULL,
      7,
      7.165107,
      1,
      0,
      6.267590,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.335400,
      NULL,
      NULL,
      7.670310,
      0,
      2.531468,
      3.810191,
      0,
      0,
      3.948939,
      NULL,
      0,
      3.939046,
      NULL,
      NULL,
      NULL,
      0,
      0.230013,
      3,
      1,
      NULL,
      0.157515,
      1.759238,
      0,
      0,
      3.806272,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3.594593,
      1,
      3,
      4,
      NULL,
      1,
      NULL,
      NULL,
      4.590004,
      1,
      0.096882,
      3.837113,
      1,
      1,
      1.834950,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462931,
      0,
      0,
      NULL,
      0,
      0.920759,
      0.875977,
      0,
      NULL,
      0.233347,
      NULL,
      0.584374,
      0,
      3,
      0.300982,
      0,
      2,
      5,
      5.153276,
      5.044459,
      7,
      5,
      NULL,
      1,
      5.496254,
      0,
      5,
      2.978115,
      0.351911,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068155,
      0.002226,
      1,
      0,
      1.465735,
      1.521526,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.106726,
      NULL,
      3,
      NULL,
      1.310273,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.869625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1.504477,
      2,
      1,
      3.550476,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.454365,
      0.860946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '32422',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      6,
      NULL,
      '4033',
      '32201',
      5.990519,
      0.473148,
      NULL,
      1.863615,
      2.481642,
      0,
      3.884731,
      3,
      2);
commit;
end;
/


