set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1211',
      '22040043',
      78,
      61,
      '1113442',
      335.846630,
      4,
      1,
      NULL,
      NULL,
      1,
      ' 3-23-2002',
      40,
      30,
      0,
      NULL,
      NULL,
      NULL,
      1.508726,
      0,
      0,
      3.137031,
      1,
      0,
      1,
      NULL,
      2,
      0.504361,
      NULL,
      0.505537,
      2.036046,
      1.139805,
      1.096877,
      0,
      1,
      2,
      NULL,
      1.105563,
      NULL,
      0,
      4.545928,
      3,
      NULL,
      1.575138,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.324555,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528703,
      1.443902,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.109189,
      0,
      NULL,
      0,
      1,
      1.805029,
      3,
      NULL,
      0,
      1.090296,
      1,
      1,
      1,
      NULL,
      1.335001,
      0,
      NULL,
      NULL,
      3.571081,
      3.485299,
      0.425973,
      0,
      1.047716,
      0,
      0.971663,
      5.767691,
      4.733009,
      4.846330,
      5,
      0,
      0,
      NULL,
      1,
      1.258620,
      5.718324,
      5.921870,
      5,
      NULL,
      NULL,
      NULL,
      4.058025,
      2,
      0.122814,
      2,
      2.361665,
      0,
      NULL,
      NULL,
      6.493837,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331693,
      0.262042,
      1,
      1,
      1.307274,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.662127,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.639010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714621,
      2.335546,
      2,
      NULL,
      NULL,
      3,
      0.197665,
      NULL,
      1,
      0,
      0,
      0.360450,
      NULL,
      NULL,
      1,
      1.728438,
      1,
      0.192626,
      0,
      1.275751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34224',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.565472,
      '4344',
      NULL,
      '',
      0,
      0,
      2,
      2.443740,
      1.816754,
      NULL,
      NULL,
      3,
      1.801087);
commit;
end;
/


