set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24303432',
      22.986631,
      74.629872,
      '4133111',
      4,
      1,
      0,
      1,
      '242332',
      4,
      ' 8-19-1978',
      3.728793,
      24,
      1.582151,
      NULL,
      NULL,
      0,
      NULL,
      0.386780,
      NULL,
      3,
      NULL,
      0.954415,
      0,
      NULL,
      5,
      0,
      4.177357,
      1.002331,
      1.124717,
      0.666844,
      NULL,
      0,
      NULL,
      1.662470,
      1.656701,
      NULL,
      5.631624,
      0,
      5.921844,
      1.370067,
      1.899923,
      0.901238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.777671,
      1,
      0.820677,
      1.257526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748184,
      0.333022,
      1.039085,
      0.473102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011432,
      0,
      0,
      2,
      0.501546,
      0,
      1.116068,
      NULL,
      1.292567,
      5.546026,
      3,
      1.554038,
      NULL,
      3.387585,
      1,
      1.638843,
      1,
      1.246120,
      0.022143,
      NULL,
      1.102269,
      0,
      1,
      1,
      0.837591,
      0,
      2.287038,
      0,
      4.879968,
      1,
      4,
      3.130945,
      0.173053,
      NULL,
      2,
      NULL,
      1,
      2.674038,
      0.223095,
      1,
      NULL,
      3.847629,
      0,
      7,
      4.100668,
      4.241131,
      NULL,
      4.552638,
      0.514984,
      NULL,
      NULL,
      8.343307,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769847,
      1.216609,
      1,
      1,
      0,
      0,
      0,
      1.572348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534390,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.619900,
      3.771736,
      0,
      6.131338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.085432,
      NULL,
      0,
      3,
      2.170407,
      1.337174,
      3,
      NULL,
      2.787202,
      0,
      1.390318,
      0,
      1.045553,
      0,
      NULL,
      1,
      0,
      NULL,
      1.009601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '34020',
      NULL,
      '',
      0.964629,
      '',
      '',
      '',
      3.016282,
      NULL,
      '',
      '',
      NULL,
      3,
      2.500120,
      2.583308,
      0,
      NULL,
      1.695773,
      1,
      0.623929);
commit;
end;
/


