set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3322',
      '22204112',
      85.115581,
      62.351872,
      '2023103',
      NULL,
      2,
      NULL,
      NULL,
      '124010',
      NULL,
      ' 9-14-1984',
      17.943426,
      15.757457,
      1,
      NULL,
      4.342516,
      1,
      0.178569,
      1.569427,
      1.118246,
      1.800033,
      NULL,
      0,
      2,
      0.633498,
      NULL,
      1.774535,
      NULL,
      2,
      1,
      1.573332,
      0.906610,
      0,
      0,
      1,
      1.220074,
      1.657477,
      0.197531,
      0,
      0.945583,
      NULL,
      0,
      0.316604,
      NULL,
      NULL,
      0.146365,
      NULL,
      NULL,
      7.233157,
      0.353306,
      0.658878,
      2,
      1.510249,
      0.585584,
      0,
      1,
      1,
      1.778001,
      0.229322,
      3,
      0.242891,
      1,
      0,
      0.833791,
      3,
      0.139117,
      0.663285,
      0.592675,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.779510,
      NULL,
      NULL,
      1,
      1,
      1.764554,
      3.868238,
      1.501942,
      3,
      1.190146,
      0,
      0.255909,
      5.867232,
      1,
      0,
      1,
      4,
      NULL,
      0.815675,
      1,
      0,
      1,
      NULL,
      1.432300,
      NULL,
      0,
      1.695273,
      0,
      2,
      1,
      0.800707,
      4.431181,
      1.135531,
      1,
      1,
      NULL,
      1.981366,
      1,
      0,
      1.288442,
      4,
      NULL,
      4,
      5,
      0,
      3,
      3.657196,
      0.256136,
      1.015576,
      NULL,
      5.622039,
      1,
      NULL,
      NULL,
      0,
      0.961615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.159808,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.584093,
      2,
      0.994856,
      0,
      1,
      0.876875,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.656076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.016307,
      0,
      3,
      0.970841,
      1,
      3.295891,
      NULL,
      NULL,
      1.376928,
      1,
      1,
      NULL,
      0.071927,
      0,
      NULL,
      NULL,
      0.887033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.750500,
      '10433',
      '44002',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '2114',
      '',
      '',
      NULL,
      3.492695,
      1,
      2,
      2,
      0,
      2,
      1,
      0.275982);
commit;
end;
/


