set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '02001300',
      NULL,
      39,
      '0321242',
      NULL,
      4,
      3.593866,
      0,
      '332211',
      NULL,
      ' 2- 2-1977',
      NULL,
      14.698786,
      1.609418,
      NULL,
      NULL,
      1,
      NULL,
      0.035893,
      1,
      0.973103,
      0.830219,
      3,
      NULL,
      1,
      3.767037,
      1,
      1,
      0,
      0.378501,
      7,
      1,
      3.353491,
      0.060938,
      0.837048,
      0.439643,
      NULL,
      6.166306,
      0,
      0.238856,
      3.260140,
      2.260661,
      1,
      NULL,
      NULL,
      1.325241,
      NULL,
      NULL,
      9,
      2,
      7,
      NULL,
      1.370913,
      0,
      1,
      2.704515,
      NULL,
      NULL,
      1,
      NULL,
      1.835015,
      1,
      3,
      1.896594,
      1,
      3.019176,
      0,
      NULL,
      1.481528,
      2.957863,
      4,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.029951,
      0.648775,
      1.805040,
      0,
      0.445680,
      1.203942,
      0.133903,
      1.606910,
      0,
      1,
      1,
      NULL,
      NULL,
      0.583201,
      NULL,
      NULL,
      1,
      0.002297,
      1.149967,
      1.661708,
      1.493948,
      NULL,
      1,
      0.303239,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150790,
      0,
      1,
      0.386648,
      6.147172,
      4,
      5.783914,
      5,
      5,
      0,
      6,
      5,
      7,
      5.918544,
      1.944611,
      5.382646,
      3.487864,
      1.471184,
      0.480643,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.298857,
      0,
      0,
      1,
      NULL,
      NULL,
      1.166742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.100593,
      NULL,
      0,
      1.875348,
      NULL,
      3.350378,
      3,
      1,
      0.238017,
      1,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686988,
      0.233027,
      4,
      2.187399,
      7.010125,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.525243,
      0.321710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257263,
      2,
      1,
      0.363288,
      0.321973,
      0,
      0.371999,
      2,
      0,
      3.271349,
      3.253021,
      0.578790,
      1.239950,
      1,
      NULL,
      0.258264,
      1.128401,
      NULL,
      1,
      0.104056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '14342',
      '',
      0.769789,
      NULL,
      '',
      '',
      3.732821,
      '1120',
      '',
      '',
      3,
      NULL,
      0.542584,
      NULL,
      1,
      1.664888,
      3.135053,
      7.793089,
      0.260491);
commit;
end;
/


