set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      NULL,
      NULL,
      17.438543,
      NULL,
      NULL,
      2,
      2.533175,
      3,
      NULL,
      0.743865,
      ' 5- 7-1996',
      44,
      NULL,
      1,
      NULL,
      1.934496,
      1,
      0,
      1.205311,
      0,
      1.170413,
      1,
      0,
      0,
      0.563998,
      4.107514,
      1.658597,
      0,
      1.027382,
      0.508734,
      1,
      0,
      1.636654,
      0,
      0.836724,
      1,
      1.623169,
      1.223067,
      NULL,
      NULL,
      3.141737,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.961220,
      NULL,
      NULL,
      0.384054,
      0.676587,
      NULL,
      2,
      1,
      1.231500,
      1,
      1,
      1.014665,
      3,
      0.102828,
      0,
      2.336096,
      0.622428,
      2.257816,
      NULL,
      1.728265,
      1,
      0,
      8.759167,
      1,
      1,
      0.424956,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195285,
      NULL,
      0.423671,
      0.170596,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.216215,
      1.661858,
      1.444270,
      1,
      0,
      NULL,
      1,
      1.247578,
      1.607723,
      NULL,
      0.738537,
      0.772216,
      1.950714,
      NULL,
      0,
      NULL,
      0,
      3.433997,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.758927,
      NULL,
      NULL,
      1,
      NULL,
      0,
      11,
      7.931700,
      6,
      NULL,
      NULL,
      3.499366,
      0,
      0,
      NULL,
      0.293823,
      0.817772,
      0,
      6.964898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.452757,
      0.156527,
      0.372527,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7,
      2.254934,
      0,
      3,
      1.653024,
      0,
      NULL,
      0.166741,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059863,
      NULL,
      NULL,
      1,
      4.471450,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225772,
      NULL,
      1.533249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414477,
      1,
      NULL,
      2.369573,
      3,
      0.312888,
      2.078930,
      3.971070,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1.704716,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.872836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '44000',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      3.290527,
      '0412',
      '',
      '',
      5.317641,
      NULL,
      0.513129,
      NULL,
      5,
      3,
      NULL,
      4,
      NULL);
commit;
end;
/


