set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '202',
      '11221032',
      NULL,
      23.070930,
      '2123312',
      NULL,
      NULL,
      NULL,
      2,
      '224011',
      6,
      ' 4- 5-1983',
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      0.626550,
      0.843983,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      0.006461,
      NULL,
      NULL,
      0,
      NULL,
      5.784360,
      2.161956,
      1,
      NULL,
      0.515410,
      0,
      0.266013,
      3,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.275007,
      NULL,
      NULL,
      4,
      10,
      1.615726,
      1.026762,
      0.450769,
      NULL,
      3,
      1,
      2,
      3.050827,
      3.368440,
      0.064878,
      3,
      3,
      3.781407,
      0.245984,
      2.833325,
      NULL,
      NULL,
      1.242939,
      1.225469,
      1,
      4.965133,
      1,
      1,
      1.804742,
      1.854933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1.665923,
      0.589182,
      NULL,
      NULL,
      NULL,
      1.067219,
      1.975340,
      0.219404,
      1,
      1,
      0,
      1.752281,
      NULL,
      0.744015,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760530,
      0,
      1,
      1.331325,
      1,
      NULL,
      1.275167,
      4.099322,
      5,
      1.352588,
      NULL,
      3,
      NULL,
      5.401287,
      1.912186,
      0.264380,
      1.859718,
      4.780699,
      9,
      7,
      10.177494,
      4,
      7,
      10,
      NULL,
      0.154004,
      NULL,
      3,
      0,
      0.487885,
      5.432247,
      0.432486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514624,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      1.887900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.653373,
      1,
      1.236647,
      1,
      NULL,
      1,
      2.833301,
      NULL,
      NULL,
      2.840884,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.812479,
      0.720089,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.358215,
      0,
      NULL,
      1,
      1,
      NULL,
      0.263316,
      1,
      0.395062,
      1.116537,
      0.582780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867074,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '42110',
      '33332',
      NULL,
      NULL,
      '',
      '',
      '',
      3.415459,
      '1220',
      '',
      NULL,
      2,
      2.227346,
      0,
      NULL,
      0.586232,
      2,
      2,
      2.102493,
      0);
commit;
end;
/


