set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '34312423',
      43.694001,
      27.010088,
      '2224204',
      3,
      5,
      2,
      3,
      '123204',
      1,
      ' 8- 8-1976',
      32,
      NULL,
      NULL,
      NULL,
      1.035268,
      1,
      0,
      0.498385,
      NULL,
      NULL,
      0,
      3.682332,
      0,
      1.312556,
      3,
      0,
      1,
      0,
      0,
      5.918379,
      NULL,
      0.023822,
      0.628884,
      1,
      1,
      NULL,
      0.205010,
      0,
      2.214127,
      NULL,
      2.119046,
      1.856835,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.197893,
      NULL,
      1.342131,
      1.743621,
      NULL,
      1,
      3,
      NULL,
      0.529416,
      3.216553,
      2,
      0,
      1.082185,
      1,
      3,
      1.218003,
      1,
      1,
      1,
      1,
      0,
      1.417939,
      3,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.579375,
      NULL,
      1,
      0.743366,
      1,
      1.322918,
      1.934681,
      NULL,
      0,
      0.495152,
      0,
      NULL,
      0,
      NULL,
      1.207399,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.914411,
      7.685512,
      8,
      3,
      4.958892,
      NULL,
      0.279223,
      0,
      6.605407,
      1.086806,
      NULL,
      1,
      3,
      NULL,
      1.507593,
      1,
      0.360768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289521,
      0,
      1,
      0.682390,
      0,
      1.272945,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.815909,
      0,
      0.955734,
      3,
      1.924309,
      1.949263,
      1,
      2,
      3.426941,
      2.167576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.142523,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.754614,
      4.614331,
      1.718579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      1.309177,
      1.247581,
      1,
      1.149966,
      NULL,
      1.780103,
      0,
      1.989389,
      1.624639,
      NULL,
      1.359105,
      0.458301,
      1,
      NULL,
      0.813549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20434',
      '24133',
      '',
      1.123858,
      NULL,
      '',
      '',
      2.960088,
      '0024',
      '',
      '',
      3,
      2.719977,
      1,
      4.385464,
      4.660268,
      NULL,
      NULL,
      1.140398,
      0.687638);
commit;
end;
/


