set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '33223322',
      51,
      33,
      '1142440',
      NULL,
      6,
      2,
      3,
      '123324',
      0,
      '11-11-1979',
      18.976124,
      45,
      NULL,
      NULL,
      1,
      1,
      3.296269,
      0,
      1,
      0.228812,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1.591455,
      0,
      1.039439,
      5.088682,
      7,
      NULL,
      1.128339,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.886711,
      1,
      0.937345,
      NULL,
      NULL,
      1.290383,
      NULL,
      NULL,
      7,
      2,
      1,
      0,
      1.465393,
      1,
      1,
      2.875350,
      0.678221,
      1.814689,
      0,
      1,
      3.468702,
      2,
      NULL,
      1,
      NULL,
      0,
      1.179323,
      1,
      NULL,
      1,
      4.284774,
      1,
      2,
      0.244212,
      0.614773,
      NULL,
      NULL,
      0.171609,
      NULL,
      NULL,
      0,
      1.828890,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.854306,
      0.570127,
      NULL,
      0,
      1,
      NULL,
      0.670341,
      0,
      0.503047,
      1.519012,
      0.701049,
      1.072628,
      NULL,
      1.074993,
      0.557955,
      NULL,
      0.377221,
      1.973724,
      1.615478,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      5.177665,
      5.102632,
      0,
      5.832999,
      NULL,
      3,
      1.656376,
      NULL,
      0.286639,
      1,
      0.023724,
      1,
      2,
      0.606831,
      0.188175,
      2.893551,
      1.650759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0.435447,
      NULL,
      1.461088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.168229,
      NULL,
      8,
      3.783300,
      0.044136,
      0.821821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016834,
      NULL,
      7,
      2.860592,
      3.429126,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.364660,
      1.925359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488353,
      1.428671,
      3.687260,
      NULL,
      2,
      0,
      0,
      1.858876,
      1.718077,
      NULL,
      1.829777,
      1.843684,
      1,
      1.221402,
      NULL,
      0,
      0,
      1.814272,
      0,
      0.280660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03110',
      '43124',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      2.305410,
      '1214',
      NULL,
      '',
      1,
      2.929073,
      2,
      4.982893,
      2.776648,
      1.767810,
      NULL,
      3,
      0);
commit;
end;
/


