set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '10024322',
      25.971815,
      NULL,
      '3204441',
      NULL,
      3,
      0,
      0,
      '403020',
      1,
      ' 6-24-1985',
      52.981815,
      54.299012,
      1.660176,
      NULL,
      1,
      1,
      3,
      0,
      0.340920,
      0.842457,
      0.131214,
      0.596695,
      NULL,
      NULL,
      1.053093,
      0.131739,
      3.627941,
      NULL,
      NULL,
      1.460042,
      4,
      1,
      0,
      1,
      1,
      0,
      3,
      1,
      0.676748,
      1.670638,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.082339,
      5.251424,
      3,
      1.435430,
      0.211002,
      1,
      NULL,
      0,
      NULL,
      3.033661,
      1.245639,
      0.188603,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0.473796,
      9.542960,
      1,
      1,
      0.632830,
      0,
      NULL,
      NULL,
      1.807571,
      NULL,
      NULL,
      0.572334,
      1,
      0,
      NULL,
      NULL,
      0.360912,
      NULL,
      NULL,
      0.992590,
      1.293172,
      1,
      1,
      0,
      0.221634,
      1.568668,
      NULL,
      0.728166,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671809,
      0.145499,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516530,
      0,
      0,
      0.943515,
      2,
      3,
      5,
      1.157385,
      NULL,
      6,
      2,
      1.545020,
      NULL,
      0,
      0,
      1.348072,
      0,
      NULL,
      NULL,
      2.851426,
      0.673137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      1.641125,
      2.580496,
      1.642482,
      1.925964,
      0,
      0,
      0,
      5.091071,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.784228,
      1.181327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.334895,
      1,
      3.192535,
      NULL,
      NULL,
      0,
      1,
      0.837261,
      0.580581,
      0.854458,
      NULL,
      1,
      NULL,
      1.350522,
      1,
      1,
      1.656784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.069502,
      '44001',
      '43232',
      '',
      1.910702,
      '',
      '',
      '',
      1.711435,
      '0213',
      '',
      '',
      0.397469,
      5.411614,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.274298);
commit;
end;
/


