set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2203',
      '14441330',
      NULL,
      NULL,
      '1412014',
      57,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      43,
      2,
      0.167712,
      NULL,
      0,
      1.876277,
      NULL,
      1,
      1.558743,
      0,
      1.631204,
      3.666363,
      1.462852,
      0,
      1.836935,
      0,
      4.721918,
      1,
      NULL,
      1.505576,
      NULL,
      1.609266,
      NULL,
      0,
      1,
      NULL,
      0.661630,
      0,
      NULL,
      2,
      0,
      0.797541,
      NULL,
      NULL,
      1.861903,
      NULL,
      NULL,
      NULL,
      6,
      3.483347,
      0,
      1,
      1.591997,
      NULL,
      2.553581,
      0.324993,
      1,
      NULL,
      0,
      2,
      3.320350,
      1.007738,
      2,
      3,
      0,
      0.161170,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.748406,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0.459495,
      1,
      0,
      0.974250,
      NULL,
      0,
      0.957923,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.753400,
      0,
      1.577248,
      1.862425,
      0,
      0,
      1,
      2.257295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.702680,
      NULL,
      NULL,
      9.832357,
      3,
      0,
      7.515063,
      3.968860,
      5.926046,
      0.322413,
      5,
      1.304927,
      0.136324,
      NULL,
      0,
      1.396533,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.834120,
      0.871620,
      1.321383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.924303,
      NULL,
      6,
      NULL,
      1,
      3,
      3,
      2,
      0,
      1.109387,
      NULL,
      7.928899,
      3.682128,
      1,
      NULL,
      NULL,
      NULL,
      0.369338,
      1.141779,
      7,
      3,
      2.424015,
      NULL,
      1.653108,
      NULL,
      NULL,
      NULL,
      0.250373,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334740,
      NULL,
      0,
      2,
      1.981981,
      0.712300,
      NULL,
      1.947496,
      0,
      NULL,
      1.422041,
      0,
      1.208059,
      1,
      0,
      0,
      1.185827,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02020',
      '22113',
      '',
      1.797420,
      '',
      '',
      '',
      2.591279,
      '1223',
      '',
      '',
      3.749207,
      1.396544,
      0,
      3,
      NULL,
      0,
      1,
      2.243482,
      1);
commit;
end;
/


