set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23402443',
      46,
      NULL,
      NULL,
      15,
      NULL,
      3,
      3,
      '331200',
      2,
      ' 6- 9-2003',
      1,
      14.027501,
      0,
      NULL,
      1.586325,
      1.744954,
      1.223299,
      0,
      0.247467,
      0,
      1,
      0.076975,
      NULL,
      0,
      6.168617,
      1,
      2.159851,
      0.866303,
      NULL,
      NULL,
      7.628525,
      0.046673,
      0,
      0,
      0.290745,
      1,
      4,
      1,
      3.129178,
      2.771787,
      0,
      1.242947,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.560165,
      0,
      5.788087,
      1,
      1.692910,
      0,
      NULL,
      0,
      0.188561,
      2.209481,
      3.688616,
      1,
      2,
      3.211045,
      0,
      2.768727,
      3.708516,
      0.923157,
      2,
      0.121675,
      0,
      NULL,
      4,
      0,
      1,
      0.321549,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812700,
      NULL,
      NULL,
      1,
      0.149194,
      0.435500,
      0.793565,
      1,
      0,
      1,
      1.580597,
      1,
      1,
      1.638274,
      1.526483,
      1.901812,
      1.360252,
      1,
      0,
      NULL,
      1.845016,
      1,
      0,
      1.728556,
      0.947491,
      0,
      1,
      2.138020,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.180677,
      0.595808,
      NULL,
      4,
      4.473573,
      1,
      NULL,
      0,
      1.302457,
      5.212957,
      9.115473,
      4.883716,
      0,
      0,
      1,
      2.545454,
      NULL,
      0.432861,
      0,
      1.278577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173753,
      1.228976,
      NULL,
      0,
      1,
      0,
      0.264606,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.157461,
      3.758572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.779939,
      NULL,
      NULL,
      NULL,
      4,
      1.105618,
      7.894080,
      NULL,
      1,
      NULL,
      0.774242,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856891,
      0.404808,
      1.192102,
      1.658299,
      2.225178,
      NULL,
      NULL,
      1.013413,
      NULL,
      1,
      2.676814,
      NULL,
      1.866023,
      0.119225,
      NULL,
      0,
      1,
      1,
      1.712436,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '22221',
      NULL,
      '',
      0.472818,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.189121,
      NULL,
      NULL,
      1,
      0.687668,
      3,
      0.354324,
      3,
      0.601810);
commit;
end;
/


