set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0114',
      '20011323',
      70,
      NULL,
      '2240232',
      117.375063,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      10.789559,
      1,
      NULL,
      NULL,
      0,
      1.983916,
      2.935759,
      0.873507,
      1,
      0.424716,
      NULL,
      3.342357,
      NULL,
      1,
      3,
      1.924272,
      NULL,
      0.844408,
      0.471388,
      1.357239,
      1,
      0,
      0.886346,
      1.544309,
      NULL,
      NULL,
      3,
      1,
      0.593159,
      1,
      NULL,
      1.436470,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      NULL,
      0,
      1.543050,
      0.717922,
      1.467935,
      0.800307,
      2,
      1.428105,
      NULL,
      3.790125,
      1.098856,
      NULL,
      2.901750,
      NULL,
      1.171727,
      2,
      1.540546,
      2,
      1.094641,
      0.319687,
      1.676106,
      5,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.477676,
      0.385944,
      NULL,
      NULL,
      0.241718,
      5,
      NULL,
      NULL,
      5.485519,
      NULL,
      NULL,
      NULL,
      5,
      0.436038,
      0.880034,
      0.224205,
      1.721650,
      NULL,
      NULL,
      0.367038,
      NULL,
      0,
      1.080265,
      0.937966,
      1.201861,
      NULL,
      3.327114,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.992026,
      1,
      1,
      2,
      0,
      6,
      9,
      5.921065,
      2,
      7.940339,
      NULL,
      NULL,
      1.278342,
      NULL,
      NULL,
      2.863362,
      NULL,
      NULL,
      1.291253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023093,
      1.293463,
      1,
      NULL,
      0.358055,
      1,
      NULL,
      1.544315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371087,
      0.949896,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.788493,
      0.629410,
      NULL,
      NULL,
      NULL,
      1.152605,
      4,
      5.219998,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.559447,
      2.158942,
      1,
      0,
      1,
      3,
      0.695909,
      0.049477,
      0.552141,
      2,
      0.871541,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '10130',
      '44004',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.010276,
      '0304',
      '',
      '',
      1.829373,
      NULL,
      3,
      NULL,
      2,
      2.419939,
      3,
      2,
      5);
commit;
end;
/


