set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1334',
      '23333411',
      41,
      39,
      '2124440',
      64.252831,
      NULL,
      1,
      3,
      '012122',
      NULL,
      NULL,
      38.536643,
      23,
      0.992971,
      NULL,
      1.319814,
      0,
      3,
      1.609418,
      0.978934,
      1.006457,
      NULL,
      0,
      0,
      1,
      3.834148,
      1,
      2,
      NULL,
      1,
      NULL,
      4.619568,
      0,
      0,
      0.393963,
      1,
      1.841234,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.219168,
      NULL,
      NULL,
      NULL,
      4.628620,
      0.489300,
      2.392330,
      1,
      1,
      0,
      0.107085,
      NULL,
      2.842533,
      3,
      0.964667,
      3,
      1,
      0.671802,
      0.475665,
      3.889616,
      0,
      1.277288,
      1.354470,
      NULL,
      0,
      9,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.317648,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      5.270657,
      1.854201,
      1.343371,
      1,
      0.909610,
      NULL,
      NULL,
      0.551342,
      0.800470,
      1.505485,
      NULL,
      0,
      0.397508,
      1,
      0,
      0,
      0,
      NULL,
      2.978829,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.987323,
      1,
      NULL,
      NULL,
      3.016634,
      6.854663,
      NULL,
      NULL,
      8.612638,
      4.048078,
      2,
      6.405103,
      4,
      1.260871,
      3,
      1,
      0.746877,
      1,
      1,
      1.388903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786902,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      2.123909,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818183,
      NULL,
      5,
      0.169170,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.626181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256285,
      NULL,
      3.483678,
      3,
      3,
      0.629083,
      1.898331,
      NULL,
      0.530519,
      3,
      0,
      0.505079,
      0,
      1,
      NULL,
      NULL,
      0.164599,
      0,
      1.341512,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '00414',
      '34134',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '4301',
      '',
      '',
      NULL,
      NULL,
      0,
      1.756865,
      0.853425,
      0,
      1,
      NULL,
      1.277160);
commit;
end;
/


