set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '33422441',
      36.300566,
      71.266489,
      '1001312',
      4,
      2,
      2.908313,
      0,
      '323402',
      2,
      ' 6-29-2001',
      49,
      52.478885,
      0.595950,
      NULL,
      NULL,
      0.407888,
      0.010257,
      NULL,
      1.449262,
      NULL,
      NULL,
      2,
      1,
      1.149383,
      7.151663,
      1.507504,
      0,
      NULL,
      5,
      NULL,
      NULL,
      2.779908,
      0,
      1.233284,
      1.891006,
      NULL,
      5.261087,
      NULL,
      2,
      0.179575,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.555793,
      0.377645,
      NULL,
      1.483392,
      1.409286,
      1,
      1,
      NULL,
      2.414108,
      1,
      2,
      1,
      3,
      2,
      1.844728,
      0.105037,
      0.653858,
      1.687331,
      0,
      0.764970,
      NULL,
      1,
      8,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0.501165,
      NULL,
      NULL,
      NULL,
      0.764663,
      NULL,
      1.863030,
      3.567410,
      NULL,
      3,
      NULL,
      NULL,
      4.877015,
      6,
      0.570901,
      0,
      7.640488,
      1.037734,
      NULL,
      NULL,
      0.990722,
      NULL,
      NULL,
      1,
      1.025407,
      4,
      NULL,
      1.473177,
      3,
      3.077510,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      1.558937,
      0,
      2,
      4,
      5.709959,
      4,
      1.340199,
      3.496844,
      3.904513,
      5,
      0,
      1.202517,
      NULL,
      0.393435,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022556,
      2,
      NULL,
      0,
      0.196873,
      0,
      0.680348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.317031,
      NULL,
      NULL,
      NULL,
      9.295757,
      0.371507,
      2,
      NULL,
      NULL,
      1,
      2.594584,
      NULL,
      NULL,
      NULL,
      1,
      3.152984,
      1.111219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140105,
      NULL,
      NULL,
      NULL,
      1.342897,
      0,
      1.277507,
      1.689541,
      NULL,
      0,
      0.053990,
      0.907974,
      0.570600,
      1,
      0,
      0,
      1.711430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '20204',
      '',
      0.931158,
      '',
      '',
      '',
      NULL,
      '13430',
      NULL,
      '',
      3,
      4.420769,
      3,
      1,
      1.323784,
      0.442209,
      0.522435,
      1.843921,
      3);
commit;
end;
/


