set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '11001020',
      39.281957,
      10.041336,
      '4241003',
      14,
      0,
      0,
      NULL,
      '424041',
      1.991701,
      NULL,
      32,
      18,
      1.092731,
      NULL,
      4.972118,
      1.788032,
      0,
      0.340469,
      0,
      NULL,
      0.069742,
      3.137709,
      1,
      0,
      5,
      1.478194,
      0,
      1.729840,
      0.463522,
      0.208991,
      6,
      NULL,
      1.603129,
      0.847406,
      0.099695,
      1.731263,
      0,
      1,
      NULL,
      1,
      NULL,
      1.454962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      6,
      1,
      1.826084,
      3,
      0.185507,
      2.148963,
      1.171879,
      0.071131,
      2,
      NULL,
      3,
      3,
      1,
      2,
      1,
      1,
      0,
      1.218937,
      1,
      0,
      2,
      1,
      1,
      3.780683,
      1.870777,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.165608,
      2,
      1.977571,
      NULL,
      NULL,
      0,
      0,
      1.094208,
      0.619857,
      0.946239,
      0,
      NULL,
      0.678357,
      3.447210,
      0.496698,
      NULL,
      NULL,
      0,
      1.744157,
      NULL,
      NULL,
      1.856478,
      3,
      1.024303,
      4,
      1,
      NULL,
      1.246790,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.809680,
      5.644460,
      0.936712,
      5.098980,
      0,
      6,
      9.055710,
      3,
      4,
      2,
      9,
      NULL,
      5.662926,
      1.755232,
      1.484588,
      3,
      NULL,
      NULL,
      0.037845,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.685666,
      0,
      0,
      0.566495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.501473,
      NULL,
      7,
      2.878973,
      1.443545,
      2.984782,
      NULL,
      NULL,
      1.708130,
      1.313985,
      4.535601,
      3,
      NULL,
      1.849827,
      NULL,
      NULL,
      NULL,
      1,
      1.865287,
      3,
      3,
      0.317321,
      2,
      1.203038,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.399237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.781417,
      1.677663,
      1,
      0.686090,
      NULL,
      NULL,
      2.158279,
      3.840439,
      1.244042,
      NULL,
      NULL,
      0.583094,
      0.285071,
      0,
      0,
      1.982600,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.297016,
      '01244',
      '43223',
      '',
      1,
      '',
      '',
      '',
      0,
      '11211',
      '',
      NULL,
      3,
      NULL,
      2.802016,
      2.877906,
      NULL,
      0,
      3,
      1.455986,
      2.209574);
commit;
end;
/


