set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01301324',
      33.795473,
      NULL,
      '4304432',
      9,
      5,
      3.865517,
      0,
      '400301',
      4.463891,
      ' 1-25-1992',
      9.132767,
      24.459776,
      0,
      NULL,
      0,
      1.959748,
      NULL,
      0,
      1,
      NULL,
      0.183515,
      3.439784,
      NULL,
      1,
      1.893581,
      1.024358,
      NULL,
      NULL,
      1.131953,
      0.651763,
      5.039682,
      NULL,
      0,
      1,
      1,
      0.468100,
      7,
      0,
      5.441164,
      NULL,
      3.261847,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.009426,
      4.333883,
      1.395465,
      3,
      1,
      0.603773,
      3,
      3,
      2,
      0,
      NULL,
      0.456814,
      NULL,
      1,
      0.232979,
      0,
      3,
      2.793525,
      2.240371,
      0,
      0,
      0,
      3.227449,
      1,
      0,
      3,
      0.259372,
      NULL,
      NULL,
      0.010032,
      NULL,
      NULL,
      0,
      6,
      NULL,
      1.781827,
      4.899372,
      3,
      2.103480,
      0.737401,
      1.259977,
      NULL,
      2.011536,
      1.475170,
      NULL,
      5.794693,
      1,
      NULL,
      0.050887,
      1,
      0.169046,
      NULL,
      0,
      1,
      0,
      NULL,
      0.989016,
      4,
      0.745318,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.789538,
      11.026421,
      2,
      NULL,
      3,
      9.428320,
      5,
      10,
      8,
      3,
      0.626725,
      2,
      NULL,
      1,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978605,
      1,
      1,
      NULL,
      NULL,
      1.163174,
      5.405074,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.475232,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.034654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613581,
      0,
      7,
      0,
      3,
      0,
      0.794377,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.654375,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1.122573,
      0.599456,
      0.889219,
      0.871335,
      NULL,
      NULL,
      1.585970,
      0,
      NULL,
      1.419693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.640354,
      '03430',
      '33203',
      '',
      0,
      '',
      '',
      NULL,
      3,
      '34230',
      '',
      NULL,
      3,
      6,
      NULL,
      0,
      2.178287,
      2.229858,
      1,
      6,
      0.292533);
commit;
end;
/


