set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '21221340',
      52,
      33.016413,
      '0413310',
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      '11- 4-2002',
      0,
      0,
      1,
      NULL,
      2,
      1,
      1,
      1.033337,
      NULL,
      1.491277,
      NULL,
      0,
      NULL,
      NULL,
      2.761769,
      1.714594,
      1,
      0,
      0,
      1,
      7,
      NULL,
      NULL,
      1.769044,
      0.075060,
      0.435147,
      7.230713,
      0,
      NULL,
      2.047858,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4.407545,
      3.288182,
      1.324301,
      1.654736,
      0.314264,
      1.372584,
      NULL,
      1,
      1.520340,
      1.804368,
      2.030777,
      0,
      1,
      0.889030,
      2,
      NULL,
      NULL,
      2.744400,
      1.146407,
      1,
      0.765359,
      NULL,
      1,
      2,
      3.256143,
      0.510612,
      NULL,
      NULL,
      0.201114,
      NULL,
      NULL,
      0,
      1,
      4.357128,
      1.483574,
      2,
      NULL,
      0.534133,
      0.434436,
      2.316888,
      3,
      3.407812,
      1.918102,
      0,
      4.534581,
      1,
      1.119734,
      1.635704,
      0,
      0,
      NULL,
      1.358679,
      0.791978,
      2.606987,
      1,
      0.595974,
      NULL,
      5.145174,
      0,
      1,
      1,
      NULL,
      NULL,
      7.081926,
      3.395430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.987739,
      8,
      0.871217,
      8,
      8.875355,
      3,
      1.122010,
      0,
      NULL,
      0.401897,
      NULL,
      7.741793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142945,
      1,
      1,
      0,
      1.056780,
      0.720722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.186778,
      NULL,
      3.637430,
      0,
      1.609052,
      NULL,
      NULL,
      0,
      5.009324,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      5.027357,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.515544,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812562,
      2.142538,
      0.526866,
      2.533518,
      2.355635,
      2.538477,
      0.954501,
      2,
      3.685800,
      3.146898,
      NULL,
      1,
      1.812257,
      0,
      1.604132,
      0.022987,
      0,
      0.329897,
      NULL,
      0.430602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.657977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.335469,
      NULL,
      NULL,
      NULL,
      1.536175,
      NULL,
      0.183773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.785776,
      NULL,
      NULL,
      NULL,
      0,
      1.268625,
      0,
      2,
      1.404180,
      '33222',
      '41123',
      '',
      0,
      '',
      '',
      '',
      0,
      '34204',
      '',
      '',
      1,
      7,
      3.416530,
      0,
      2,
      NULL,
      NULL,
      5.022480,
      1);
commit;
end;
/


