set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1114',
      '43413332',
      31,
      0.518729,
      '1232342',
      56,
      1,
      NULL,
      3,
      '333034',
      5,
      ' 5-16-1983',
      18.523266,
      23,
      1,
      NULL,
      NULL,
      1.795340,
      1,
      0,
      0.396209,
      2.851233,
      1.534348,
      3.597316,
      1.628506,
      0.625077,
      5,
      NULL,
      NULL,
      1.745722,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.432090,
      5,
      NULL,
      0.638994,
      3,
      2.990134,
      0,
      NULL,
      NULL,
      0.337217,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      1.361907,
      3.692951,
      0,
      0.358386,
      1,
      3.086227,
      0.393055,
      1.221690,
      NULL,
      1.273493,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      1.250215,
      NULL,
      NULL,
      0.108024,
      NULL,
      NULL,
      NULL,
      4.103725,
      3.044031,
      1,
      1,
      3,
      NULL,
      0.164962,
      0,
      0,
      1.648198,
      1,
      0.269333,
      3,
      0,
      0,
      1.159796,
      1.633903,
      1.241324,
      NULL,
      1.646238,
      1.747437,
      2.337531,
      3.962924,
      1,
      NULL,
      2.064781,
      1,
      NULL,
      1.157735,
      1,
      NULL,
      3,
      1.522453,
      4.472721,
      0.175612,
      NULL,
      0.333418,
      7,
      4.055588,
      NULL,
      1,
      3.694673,
      2,
      8.687271,
      1.055488,
      4.019523,
      2,
      3.658866,
      0,
      0.285577,
      5.191660,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565465,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515296,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.012796,
      3.435733,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.055177,
      7,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.032926,
      NULL,
      0.621351,
      NULL,
      0.573251,
      1.047048,
      2,
      0,
      0.514834,
      3,
      0,
      1.895613,
      0.906967,
      NULL,
      1,
      1.734592,
      0,
      1.420993,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '21414',
      '34410',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      '',
      NULL,
      0.178145,
      NULL,
      3,
      1.366054,
      1,
      NULL,
      0,
      NULL,
      NULL);
commit;
end;
/


